#include <string.h>
#include <ncurses.h>
#include "keyb.h"

int
processinput (char *inputline, int key)
{
  switch (key)
    {
    case KEY_UP:
      return KEY_UP;

    case KEY_DOWN:
      return KEY_DOWN;

    case KEY_LEFT:
    case KEY_RIGHT:
      return ESUCCESS;

    case ESC:
      {
	return EEXIT;
      }
    case RETURN:
      {
	return ERETURN;
      }
    case BACKSPACE:
      {
	if (strlen (inputline) != 0)
	  {
	    inputline[strlen (inputline) - 1] = '\0';
	    return EBACK;
	  }
	return -EBACK;
      }
    default:
      {
	if (strlen (inputline) > 254)
	  return EMAXLEN;
	inputline[strlen (inputline)] = key;
      }
    }
  return ESUCCESS;
}
