/***************************************************************************
                          Apollonlistview.cpp  -  description
                             -------------------
    begin                : Thr 14 2003
    copyright            : (C) 2003 by David Sansome
    email                : me@davidsansome.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "apollonlistview.h"
#include "apollontransferviewitem.h"
 
#include <qheader.h>
 
ApollonListView::ApollonListView(QWidget* parent)
 : KListView(parent)
{
	connect ( header(),SIGNAL( sizeChange ( int, int, int ) ),
		this, SLOT( slotAdjustGeometry() ) );
	connect ( header(),SIGNAL( indexChange ( int, int, int ) ),
		this, SLOT( slotAdjustGeometry() ) );
	connect ( this, SIGNAL( expanded( QListViewItem * ) ),
		this, SLOT( slotAdjustGeometry() ) );
	connect ( this, SIGNAL( collapsed( QListViewItem * ) ),
		this, SLOT( slotAdjustGeometry() ) );
}


QSize ApollonListView::sizeHint() const
{
	return QSize(1, 1);
}

QSize ApollonListView::minimumSizeHint() const
{
	return QSize(1, 1);
}

QSize ApollonListView::minimumSize() const
{
	return QSize(1, 1);
}

void ApollonListView::resizeEvent( QResizeEvent* e )
{
	QListView::resizeEvent( e );
	slotAdjustGeometry();
}

void ApollonListView::slotAdjustGeometry()
{
	for (QListViewItemIterator it( this ); it.current(); it++)
	{
		if (it.current()->rtti() != 1463)
			continue;
		ApollonTransferViewItem *i = static_cast<ApollonTransferViewItem*>( it.current() );
		i->adjustGeometry();
	}
}

void ApollonListView::setProgressBarType(int type)
{
	for (QListViewItemIterator it( this ); it.current(); it++)
	{
		if (it.current()->rtti() != 1463)
			continue;
		ApollonTransferViewItem *i = static_cast<ApollonTransferViewItem*>( it.current() );
		i->setProgressBarType(type);
	}
}


