//
// C++ Interface: apollonchattab
//
// Description: 
//
//
// Author: Martin Koebele <martin@mkoebele.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef APOLLONCHATTAB_H
#define APOLLONCHATTAB_H

#include "apollonchatiface.h"
#include "apollonsystemtray.h"
#include <qwidget.h>

class KLineEdit;
class KIRC;

class IrcToHtml
{
public:
	IrcToHtml() {};
	~IrcToHtml() {};
	
	QString parse(const QString & ircText);
	
	QString ircColorToHex(int color);
	
private:
	bool findTag(const QString & name);
 	QString closeTag(const QString & name);
	
	QStringList tags;
};

class ApollonChatTab : public ApollonChatIface
{
	Q_OBJECT
			
	public:
		ApollonChatTab( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~ApollonChatTab();
		
	public slots:
		void clickChangeNick();
		void appendLine(const QString& text);
		void setTray(ApollonSystemTray *tray);
		void setShowPopup(int show);
		
	private:
		KLineEdit *m_editNick;
		KIRC* kirc;
		enum
		{
			Disconnected,
			Connecting,
			Connected
		} m_connectionState;
		void initKIRC();
		int colorOf(const QString& name);
		
		QString m_nickName;
		QStringList m_nickList;
		int m_nickIndex;
		QString m_oldLineText;
		bool coloredNicks;
		ApollonSystemTray *m_systemTray;
		int m_showPopup;
		
		void deleteNick(QString nick);
		
		typedef enum NickOp 
		{
			ADD_NICK=0, 
			DELETE_NICK,
			CHANGE_NICK
		};
		void changeNickList(NickOp op, const QString& nick1, const QString& nick2=QString::null);
		
		bool event(QEvent* e);
		
	private slots:
		void slotConnected();
		
		void slotIncomingMessage(const QString& , const QString& , const QString& );
		
		void sendMessage();
		void slotJoinChannel();
		void slotNickList(const QString&, const QStringList&);
		void slotNickChange(const QString &, const QString &);
		void slotPartedChannel(const QString &nick,const QString &channel, const QString &reason);
		void slotJoinedChannel(const QString &nick, const QString &channel);
		void slotGenerateNewNick(const QString&);
		void slotQuitChannel(const QString &, const QString &);
		void slotTopicChange(const QString &, const QString &, const QString &);
		void slotExistingTopic(const QString &, const QString &);
		void slotNickChanged(const QString &, const QString &);
		
		
		
};
#endif
