#! /usr/bin/env python
# Part of the A-A-P recipe executive: Separate program that installs packages

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

# This programs runs as root to be able to invoke pkg_add.
# Stdin and stdout should be piped by popenerr.py.

import sys
import os


if __name__ == '__main__':
    # Print a message so that the invoking process knows we're ready for
    # commands.
    print "PkgInstall ready"
    sys.stdout.flush()

    # We have been started by "popenerr", need to fix stdin.
    os.close(0)
    n = os.dup(2)
    if n <> 0:
        print 'PkgInstall: bad stdin dup: %d\n' % n
    # Duplicated stderr from stdout, so that the other side only needs to read
    # one stream.
    os.close(2)
    n = os.dup(1)
    if n <> 2:
        print 'PkgInstall: bad stderr dup: %d\n' % n

    while 1:
        cmd = sys.stdin.readline()
        if cmd[0] == 'I':
            try:
                res = os.system('pkg_add %s' % cmd[1:])
            except:
                res = 1
            if res:
                print "PkgInstall failed"
            else:
                print "PkgInstall OK"
            sys.stdout.flush()
        elif cmd[0] == 'Q':
            sys.exit(0)
        else:
            print 'PkgInstall error: unrecognized command: "%s"' % cmd


# vim: set sw=4 et sts=4 tw=79 fo+=l:
